% Cryptology Annual News Update and Vignette
% Bill Ricker
  for [BLU.org](http://blu.org/cgi-bin/calendar/2025-sep)
% Sept 17, 2025

1. Cryptology News Bulletins
2. Post Quantum Cryptograpy update
3. Historic Vignette
4. Bibliography

# 1 Cryptology News Bulletins 2024-09 to 2025-09

**"Abundance of Caution"** is C-suite lingo for _"Oopsie, oh flying squirrel"_

------------

## Let's Encrypt: short-lived certificates &c



* [LetsEncrypt Dec. editorial](https://letsencrypt.org/2024/12/11/eoy-letter-2024) announced automatically renewable 6-day server TLS certificates, using the same automation used for the free 90-day certs. 
    * Slashdot hated it; 
    * [Schneier](https://www.schneier.com/blog/archives/2024/12/short-lived-certificates-coming-to-lets-encrypt.html) liked it. 
    * [First issued Feb. 2025](https://letsencrypt.org/2025/02/20/first-short-lived-cert-issued). 
    * It was approximately LE's 10th anniversary.

In other news

* Now issuing [IP Address certificates](https://letsencrypt.org/2025/07/01/issuing-our-first-ip-address-certificate), 
* Turned off 
    * [Online Certificate Status Protocol (OCSP) ](https://letsencrypt.org/2025/08/06/ocsp-service-has-reached-end-of-life)  
        (in favor of Revocation Lists only) 
    * [Expiration Notification](https://letsencrypt.org/2025/06/26/expiration-notification-service-has-ended) 
        as renewal automation has spread, reducing their retained PII; 
* announced [phased shutdown](https://letsencrypt.org/2025/08/14/rfc-6962-logs-eol) of  RFC 6962 Certificate Transparency Logs
    (in favor of Static Certificate Transparency API);   
    timed to allow browsers to catch up.



----

### NOTES on Let's Encrypt 2025

Revocation of certs is a solution that creates more problems (centralized, DoS, ...). The alternative is to discard certificates frequently. (This is more plausible for server certs than for email certs, where one would like to be able to decrypt a message when it's relevant, not have to decrypt immediately upon receipt.)  This also limits the window of vulnerability of TLS server cert and private key saved in publicly readable cloud backups / staging areas / GitHub repos / container repo; the private key expires 6 days after received; save a(n almost) stale key to the repo, discloses nothing, and autoupdates?


---



---

## UK NCSC advice on 'Advanced Cryptography'

[UK white paper](https://www.ncsc.gov.uk/whitepaper/advanced-cryptography)
[Schneier & friends comments](https://www.schneier.com/blog/archives/2025/05/ncsc-guidance-on-advanced-cryptography.html) 

**Advanced** := *Beyond* protecteding **data at rest** and **data in motion**; allowing some **processing** of protected data.

Their examples:

* Homomorphic encryption
* Private information retrieval
* Multiparty computation
* Zero-knowledge proofs
* Private set intersection revealing your whole list
* Attribute-based encryption attributes

key takeaways are 

* Don't roll your own security code (per usual)
* these techniques are immature so get best help




### Notes on Advanced Cryptography

Their gloss of their examples:

* Homomorphic encryption:  
    performing calculations directly on encrypted data
* Private information retrieval:  
    conducting a query into a database, without revealing the query to the owner of the database
* Multiparty computation:  
    carrying out a calculation cooperatively, but without sharing secret inputs
* Zero-knowledge proofs:  
    proving the possession of some secret knowledge without revealing it
* Private set intersection:  
    learning which data items you have in common with someone else, without revealing your whole list
* Attribute-based encryption:  
    limiting decryption of messages to anyone possessing a specific set of attributes

---



---

## NIST revised password rules

[NIST SP 800-63 Digital Identity Guidelines](https://pages.nist.gov/800-63-4/){ .title_ish }
includes passwords. This is officially only applicable to Federal information systems, but constitutes a best practice for the rest of us to be aware of.

[Schneier on 2024 draft's password rules](https://www.schneier.com/blog/archives/2024/09/nist-recommends-some-common-sense-password-rules.html)

---

## Attacks only get better: GPU assisted Brute Force

![Nvidia-RTX-4090](Images/Nvidia-RTX-4090.jpg)
['GPU Assisted Brute Force Cryptanalysis of GPRS, GSM, RFID, and TETRA: Brute Force Cryptanalysis of KASUMI, SPECK, and TEA3.'](https://tosc.iacr.org/index.php/ToSC/article/view/12078/11919){.title_ish}

These are actual wireless communications protocols' keys.

This research shows that *some* key-sizes are within brute-force *now* with state-actor scale (e.g. Top500) clusters of GPUs or hypothetical specialized hardware, and others may be in range by 2050. 


[Schneier &c](https://www.schneier.com/blog/archives/2025/03/improvements-in-brute-force-attacks.html)




----

### NOTES

Venona-level persistence-play is already in play^[see the [&#x2673; Review: Forward Secrecy](#review-generalization-of-forward-secrecy){.title_ish} slide in 2, and BLU 2018 footnotes below]. 
Today's cellphone intercepts may be cracked in the future.
For the highest priority, investigators may be willing to dedicate a cluster for a year to get the session-key for a previously recorded conversation. And it will only get more affordable.


---



---

## What to use instead of PGP, FB IM, ...

Updating our prior discussions (in 
2019^[[2019 what to use](https://blu.org/meetings/2019/09/Crypto2019.flipbook/#page/n7), initial suggestions by use-case;], 
2021^[[2021 what to use](https://blu.org/meetings/2021/09/BLU.2021-09-15.Ricker.flipbook/#page/n9), 2019&#x2673; with added caveat Keybase sold to Zoom;], 
and 
2022^[[2022 what to use](https://blu.org/meetings/2022/09/Cryptology_Annual_News_Update_and_Vignette_SLIDES.flipbook/#page/n3), 2019&#x2673; with a governmental PGP use failure;]):

### Nov. 2024: [What To Use Instead of PGP](https://soatok.blog/2024/11/15/what-to-use-instead-of-pgp/){.title_ish}

_Nice discussion by use-case by a cryptologist who finds vulns._
_By Use Case is important, as the flaws in PGP/GPG usage largely come from trying to be the one Swiss Army Knife to pound all nails._



----

### NOTES

_Covers use-cases:_  

* Signing software distributions
* Signing Git ... tags/commits 
    (_FWIW, since then they're recommending Codeberg instead of GitHub._)
* Sending files between computers
* Encrypting Backups 
* Encrypting Application Data
* Encrypting Files
* Private Messaging
* Identity Verification
* Encrypted Email (_tl;dr: no, just don't. use the PM suggestions instead._)

---



### Apr.2025: [Neiman Lab: How to leak to a journalist](https://www.niemanlab.org/2025/04/how-to-leak-to-a-journalist/){.title_ish} 

_tl;dr:_![Classic Alice+Bob cryptographic diagram with added "A The Atlantic" in lower-middle, tapping connection, where "Eve the evesdropper" is usually located. That's the whole joke.](Images/Alice+Bob+Atlantic.png){ .float_r} 

* SecureDrop
* Signal 
* Whistle blower support services


But even with Signal secure group messages, OpSec requires you not add the _wrong_ person from your Contacts!



----

### NOTES


Key notes from [Schneier &friends comments](https://www.schneier.com/blog/archives/2025/04/how-to-leak-to-a-journalist.html)

* When connecting from home with personal device, be sure Work VPN is disabled!
* [The Guardian's how to contact](https://manage.theguardian.com/help-centre/article/contact-a-journalist-or-editorial-desk) has a [guide](https://www.theguardian.com/tips) and a SecureDrop portal.

Also, reminder that **Telegram** doesn't default to secure, and even when security is enabled, it's only for 1-to-1 not group chats. Telegram is find 

And as always **YMMV**, evaluate _your_ **threat-model**.

---




---

# 2 What's up with Post Quantum Cryptography?

## Review: What's Quantum Computing?

&#x2673;
Reprises (&#x2673;) and updates last major PQC status update [Sept 2022](blu.org/meetings/2022/09/Cryptology_Annual_News_Update_and_Vignette_NOTES.flipbook/#page/n1) which is excerpted below with recycled "&#x2673; Review" markings.

![](Images/schrodinger.jpg){#catbit width=25% .float_r }

[Quantum Superposition](https://en.wikipedia.org/wiki/Quantum_superposition) when used for computing.

* QC measured in **"qubits"** not bits
* 30% True, 70% False.



----

> Such bits are in quantum superposition of True and False, which is a *bug* in classical computing but a *feature* in QC.

> This allows [non-deterministic algorithms](https://en.wikipedia.org/wiki/Nondeterministic_algorithm).

---



---

### &#x2673; Review: Kinds of Quantum Hardware

- [Quantum Annealing](https://en.wikipedia.org/wiki/Quantum_annealing) - big qubit counts, great for optimization problems




     **but not cryptology.** (?yet? well maybe ...) _Not general purpose._



- [Quantum Circuit/Logic](https://en.wikipedia.org/wiki/Quantum_circuit) - small numbers of qubits so far.



--- 


> In theory, algorithms for these hardware types can use non-deterministic parallelism to evade classical performance limits, and in particular, could allow factoring fast enough to be dangerous, provided big enough quantum circuits can be made to work.

----



---

### &#x2673; Review: We're discussing PQC before QC?

Yes !

![](Images/Post-Quanten-bar.png){width=50% .float_r}

* [**Quantum Cryptography**](https://en.wikipedia.org/wiki/Quantum_cryptography) 

    - theoretically using entangled quantum states
    - to create an encryption 
    - or an anti-eaves-droppable connection

* Quantum Crypt**analysis**

    - Using Quantum Computing to defeat classical PKI encryption 

* [**Post Quantum Cryptography**](https://en.wikipedia.org/wiki/Post-quantum_cryptography) 

    - new classical encryptions that can resist Quantum Cryptanalysis, 
    - so read as Ready for post-**(**Quantum-<u>Computing</u>**)** Cryptography.

----

### Review: What's the problem?

&#x2673;

* Unbreakable ciphers aren't always unbreakable, for always.
* QC *could theoretically* break most PKI
    - Schor's Algorithm / Grover's / VQF
    - discrete log as well as prime factoring, even elliptic curves
* **2024-01-05** [Improving Shor's Algorithm](https://www.schneier.com/blog/archives/2024/01/improving-shors-algorithm.html)
    - ["Thirty Years Later, a Speed Boost for Quantum Factoring" (Quanta)](https://www.quantamagazine.org/thirty-years-later-a-speed-boost-for-quantum-factoring-20231017/)
    - Oded Regev's paper on [arXive](https://arxiv.org/abs/2308.06572)
    - and another team already reduced the memory penalty of the speed improvement [arXiv](https://arxiv.org/abs/2310.00899)




----

### NOTES

Every unbreakable cipher has been broken eventually (at least partially^[See our [prior discussions](http://blu.org/meetings/2018/09/) of GEE, VENONA for breaks of One Time Pad, e.g. [20182](https://blu.org/meetings/2018/09/Crypto-news-2018.flipbook/#page/n7)]).

20thC RSA and other PKI not guaranteed proof against either of:

- major breakthrough in number theory (factoring &/or discrete log), or  
- quantum hardware + algorithms (practical fast factoring )

[Schor's Algorithm](https://quantum-computing.ibm.com/composer/docs/iqx/guide/shors-algorithm) in theory would factor fast on enough quantum circuits but 21 is not a large number yet. ([see also Wikipedia](https://en.wikipedia.org/wiki/Shor%27s_algorithm). Some say 433 bits on IBM Osprey QC is enough for RSA2048 with Schor's algo needing 372 Qubits (with pre-processing and post-processing), but will it work? [Schneier and Schor doubt it.](https://www.schneier.com/blog/archives/2023/01/breaking-rsa-with-a-quantum-computer.html) _Shouldn't someone try it?_)

Other probabilistic quantum algorithms ([Grover](https://en.wikipedia.org/wiki/Grover%27s_algorithm), [GEECM](https://en.wikipedia.org/wiki/Lenstra_elliptic-curve_factorization#Quantum_version_(GEECM)), [Variational Quantum Factoring (VQF)](https://arxiv.org/abs/2012.07825)) can do _some_ much bigger numbers (_which may just define new class of unsafe primes??_), and with classical pre-processing, can use a much smaller number of qubits than the \^_obvious_\^ log~2~N.

_not clear this will ever be able to generally break RSA4096, but it's not impossible, so prudent to plan for that day._

---



## 2025 GOOGLE WILLOW QC 

(Hype, not yet dangerous)

[BBC: Google unveils 'mind-boggling' quantum computing chip](https://www.bbc.com/news/articles/c791ng0zvl3o){ .title_ish }

[MSN: Google's Willow quantum chip breakthrough is hidden behind a questionable benchmark](https://www.msn.com/en-us/money/other/googles-willow-quantum-chip-breakthrough-is-hidden-behind-a-questionable-benchmark/ar-AA1vyNwG){ .title_ish }

See caveats on Wikipedia ^[[Wikipedia 2025-08-08](https://en.wikipedia.org/wiki/Willow_processor#Criticism)]:

> Per Google company's claim, Willow is the first chip to achieve below threshold quantum error correction.[1][2]
> However, a number of critics have pointed out several limitations:

(_quoted at length in notes_)



----

### NOTES on Willow

[Wikipedia Willow_processor, #Criticism, 2025-08-08](https://en.wikipedia.org/wiki/Willow_processor#Criticism) continuing:

>    The logical error rates reported (around 0.14% per cycle) remain orders of magnitude above the 10\^6 levels believed necessary for running meaningful, large-scale quantum algorithms.[9]
    To date, demonstrations have been limited to quantum memory and the preservation of logical qubits'without yet showing below'threshold performance of logical gate operations required for universal fault'tolerant computation.[10]
    Media coverage has been accused of overstating Willow's practical significance; although error suppression scales exponentially with qubit count, no large'scale quantum algorithms or commercial applications have yet been demonstrated on Willow.[11]
    Observers caution that achieving below'threshold error correction is only one milestone on the path to practical quantum computing'further hardware improvements (lower physical error rates) and vastly larger qubit arrays will be required before industrially relevant problem'solving is possible.[12]
    Some experts note that Willow remains a research prototype within the Noisy intermediate-scale quantum era, still far from delivering the practical, fault'tolerant performance required for real'world applications.[13]

---



---

##  Review: Generalization of Forward Secrecy 

&#x2673;
* Classical "Forward Secrecy" property requires tha old messages not broken by _later_ loss/compromise of host key

* Generalized: old saved messages not broken by later breakthroughs either.

* Realistic threat? ![_Greenpeace mashup c/o Wikimedia_](https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Airship_flying_over_the_Utah_Data_Center_03.jpg/800px-Airship_flying_over_the_Utah_Data_Center_03.jpg){#greenpeace .float_r}

    - Saved messages have been decrypted with later breakthrus before.
    - VENONA + GEE 1940s ^[see BLU Sept 2018 Venona footnote above]
    - [NSA Utah Data farm, 2013](https://en.wikipedia.org/wiki/Utah_Data_Center#Structure) 



----

### NOTES

    * VENONA: It worked Once! ^[see BLU Sept 2018 footnote above]
    * We now have a Vacuum Cleaner of Holding (_Greenpeace photo c/o Wikimedia_)

So yes, it **can** happen again.

Normal [Forward Secrecy](https://en.wikipedia.org/wiki/Forward_secrecy) requires that if e.g. the Host Key is compromised later, any retained cryptograms sent with nonce keys negotiated with the compromised Host Key aren't also compromised.

This is nice, but we'd also like to protect against advances of technology, e.g. fast factoring or solutions of discrete logs or even massively parallel brute-force key-search on Top500 scale GPU clusters^[2025 [1 Attacks only get better](#attacks-only-get-better-gpu-assisted-brute-force) above].

This may not be within _your_ threat model, yet, but in dystopian plausible futures, things you've already discussed/downloaded might be retroactively illegal/disloyal and oops.

---



## Review: NIST Post-Quantum Cryptography Standards

&#x2673;

> The goal of post-quantum cryptography (also called quantum-resistant cryptography) is to develop cryptographic systems that are secure against both quantum and classical computers, and can interoperate with existing communications protocols and networks. -- **NIST**

###  Review: NIST PQC Competition

&#x2673;

National Institute of Standards & Technology started a multi-round competition, similar to with AES and SHA3 competitions 


- [NIST announcement](https://csrc.nist.gov/projects/post-quantum-cryptography)  
- [NIST Q&A](https://www.nist.gov/blogs/taking-measure/post-quantum-cryptography-qa-nists-matt-scholl)
- [Schneier on PQC](https://www.schneier.com/blog/archives/2022/08/nists-post-quantum-cryptography-standards.html)




----

### NOTES

NIST, the Bureaucracy formerly known as NBS. 

_Goal is to have PQC ready for use not only **before** quantum breakthrough but early enough (roughly now) that anyone who wishes to avoid save-intercepts-now-to-break later can switch quickly; although it may already be too late WRTO NSA archive?_

_This competition was "more brutal" than prior; of 69 candidates, peer cryptanalysis has broken 62. So far._

---



----

## Review: Quantum Cracking 2023

&#x2673;

* **RSA2048 in play or not?** - Chinese academic paper claiming 2k bit RSA within range of current gen NON-fault-tolerant QC, no great surprise given Qubits available and theoretical algorithm size. Schor and Schneier unconvinced  - does it actually converge w/o FT? [Schneier 2023-01](https://www.schneier.com/blog/archives/2023/01/breaking-rsa-with-a-quantum-computer.html)

* [Schneier "You Can't Rush PQC Standards"](https://www.schneier.com/blog/archives/2023/08/you-cant-rush-post-quantum-computing-standards.html)

* [Quantum resistant hybrid-signing FIDO2 keys for 2FA](https://youtu.be/QrAbO5G6UnM?si=Q4pI7YcLf1jUQ92H)

* [**Side-Channel Attack against CRYSTALS-Kyber**](https://www.schneier.com/blog/archives/2023/02/side-channel-attack-against-crystals-kyber.html)

![](Images/Star-Trek-The-Original-Series-Burnt-Dilithium-Crystal-on-Display.jpeg){width=30% .float_r}

> [2023.02.28] CRYSTALS-Kyber is one of the public-key algorithms currently recommended by NIST as part of its post-quantum cryptography standardization process.
> Researchers have just published a side-channel attack'using power consumption'against an implementation of the algorithm that was supposed to be resistant against that sort of attack.
> The algorithm is not 'broken' or 'cracked''despite headlines to the contrary'this is just a side-channel attack. What makes this work really interesting is that the researchers used a machine-learning model to train the system to exploit the side channel.

OTOH as seen in TETRA:BURST, a side-channel attack can be used to extract key or algorithm from a piece of equipment that falls into opponent lab.

---

### Review: Known weaknesses

&#x2673;

![](Images/Dilbert_random.gif){ width=50% .float_r }

- breaks eliminated 62 of 69 entrants in Rounds 1 to 4  
- including the two front-runners, Rainbow and SIKE  
- 7 remain, will they survive?
- FALCON would be compromised by a lack-of-randomness in salt, or failure to salt, as repeating same key and hash again gives too much information.

### Isn't non-random or uniformly-blank Salt an unlikely failure?

TL;DR ***No. It's happened.*** (_see in notes_)



----

### NOTES

Lack of randomness failure isn't just hypothetical, lots of SSH keys got invalidated in 2008 because they were well-known-primes. 

* Numerous implementations have failed to salt encryption of small data despite warnings.
* DEBIAN broke system `random`^[`DSA-1571-1 openssl` [predictable random number generator](https://www.debian.org/security/2008/dsa-1571)  {[CVE-2008-0166](https://security-tracker.debian.org/tracker/CVE-2008-0166)} {[Schneier](https://www.schneier.com/blog/archives/2008/05/random_number_b.html)} which compromised many SSH keys.
* our historical vignette in prior years has discussed danger of key reuse in WW2 and Cold War. Lack of Salt = Key Reuse.

(**WTAF**? Yep. Debian packagers applying _normal best practices_ where they shouldn't even touch (Normal doesn't apply!) had _removed_ the entropy-harvesting because Valgrind and Purify gave `accessing uninitialized memory` warnings. Well yeah, *that's how we harvest entropy*! Another problem (mostly solved?) is host key generation at VM start - the VM's entropy is rather deterministic (biased) at that point. Similarly, optimizing compilers removing zeroing memory prior to releasing it can allow keys to leak into the memory pool. Cryptographic software is an ongoing a battle against computer \^science\^ that \^knows better\^.)

And failure to salt wouldn't surprise me when non-specialists (applications developers, database programmers, protocol developers) who should stick to packaged PKI use-case libraries (e.g. [**NaCl**](https://en.wikipedia.org/wiki/NaCl_(software))) try to use cryptographic primitive routines directly to avoid dependencies.)

2023 added few more low-entropy initialization examples added to the list.

And 2024's PuTTY key disclosure was due to implementing low-entropy nonces badly for use in VMs and everywhere else.

_Won't someone think of the random numbers?_




------------------

## NIST PQC Timeline (updated)

* 2022-04-28 [How to Prepare Your PKI for Quantum Computing](https://www.keyfactor.com/blog/how-to-prepare-your-pki-for-quantum-computing) (April 28, 2022)
* 2023-03-03   [Post-Quantum Cryptography Conference](https://pkic.org/events/2023/post-quantum-cryptography-conference/) (Friday March 3, 2023 - Ottawa, Canada)
* 2023-08      [FRN RFC](https://csrc.nist.gov/news/2023/three-draft-fips-for-post-quantum-cryptography) Draft Standards FIPS 203, 204, 205.
* 2024-04      Fifth PQC Standardization Conference 
* 2024-08-15   FIPS Standards; `FIPS Allowed`: NIST announced finalized PQC standards for 3 of 4 "winners" (3 more to come)
    *   [FIPS 203](https://csrc.nist.gov/pubs/fips/203/final): Module-Lattice-Based Key-Encapsulation Mechanism Standard (ML-KEM)
        * proposed as "CRYSTALS-Kyber"
        * general encryption (payload symmetric key encapsulation), for data in motion
        * August 2024
    *   [FIPS 204](https://csrc.nist.gov/pubs/fips/204/final): Module-Lattice-Based Digital Signature Standard (ML-DSA)
        * proposed as "CRYSTALS-Dilithium"
        * Digital Signatures, authentication
        * August 2024
    *   [FIPS 205](https://csrc.nist.gov/pubs/fips/205/final): Stateless Hash-Based Digital Signature Standard (ML-DSS; SLH-DSA)
        * proposed as Spincs+
        * Digital Signatures, authentication
        * August 2024
* 2024-10-24   PQDSS Round 2 starts
* 2025-03-11   future FIPS 207 HQC-KEM selected from PQKEM round 4.
* 2025-08-28  FIPS 206 Draft (FN-DSA) submitted
* ..... you are here .....
* 2025-09-24 ' Sixth PQC Standardization Conference
    _the week after this annual talk, so expect more news soon!_
    [Conference page](https://csrc.nist.gov/events/2025/sixth-pqc-standardization-conference) has Agenda; already has 2 sessions on Cryptanlysis of PQDSS Round 2.
* 2025/26         FIPS <u>certification</u> for the PQC algorithms; `FIPS Approved`.
* .... and eventually, FIPS disapproval/phase-out/banishment of non-PQC legacy algorithms ...


[NIST PQC](https://www.nist.gov/programs-projects/post-quantum-cryptography)

## 2025 NIST PQC FIPS 206 FN-DSA draft

A year ago, NIST finalized 3 FIPS PQC standards and selection of several PQC algorithms (1 KEM, 2 DSA). Since then, a few more have progressed through the process.

* FIPS 206 draft submitted Falcon / FN-DSA
    * FN-DSA (Falcon, also DSA) was scheduled for finalization later in 2024 but has only just been submitted as draft standard August, 2025  
        > Nov 7, 2024 Falcon (to be renamed FN-DSA) seems much better than SLH-DSA and ML-DSA if you look only at the numbers in the table. There is a catch though. For fast signing, Falcon requires fast floating-point arithmetic, which turns out to be difficult to implement securely.
        [CloudFlare](https://blog.cloudflare.com/another-look-at-pq-signatures/)

"Securely" presumably is regarding **timing**.

Cryptographic math wants to be not only one-way functions but (in a world where encryption is often on a shared CPU) not only fixed time but also fixed tempo, to avoid side-channel (power, CPU%, memory access pattern, ...) disclosure of key bits or key correlatives.

## 2024-OCT NIST PQC DSA Round 2 

* Round 2 DSA candidates, October 2024: 14 new candidates (looking for diversity) &#x2673;
    * CROSS Codes and Restricted Objects Signature Scheme
    * LESS Linear Equivalence Signature Scheme
    * SQIsign
    * HAWK
    * Mirath (MIRA+MiRitH)
    * MQOM MQ on my Mind
    * PERK
    * RYDE
    * SDitH Syndrome Decoding in the Head
    * MAYO
    * QR-UOV
    * SNOVA
    * UOV Unbalanced Oil and Vinegar
    * FAEST

## 2025 future FIPS-207 selected Hamming Quasi-Cyclic (HQC, KEM)

* *selected* from fourth round candidates
* "backup for ML-KEM", "different math"
* Key-Encapsulation Mechanism (KEM), for data in motion
* selected March 2025; targetting draft standard 2026, final FIPS 2027
* this selection sidelines the other fourth-round contenders BIKE (close), Classic McEliece (deferred pending ISO; huge keys), SIKE (broken).
* HQC had the simplest hardness assumptions.

## 2024/2025 Related NIST

### Random Bits

NIST SP 800-90A PRE-DRAFT Call for Comments: **Recommendation for Random Number Generation Using Deterministic Random Bit Generators**

* requesting comments on draft Rev.1 prior to producing Rev.2

### AES 256 (2025)

c/o [🐘](https://fosstodon.org/@atoponce/113728504824287204)

Dec. 2024: NIST proposed a 256-bit block variant of AES with a static 256-bit key size. 

Public comments were open until January 25, 2025.

[NIST PR](https://www.nist.gov/news-events/news/2024/12/nist-proposes-standardize-wider-variant-aes)





----



---

### Notes - Post-Quantum Cryptography citations

[Schneier](https://www.schneier.com/blog/archives/2024/08/nist-releases-first-post-quantum-encryption-algorithms.html); [Fed.Reg.](https://www.govinfo.gov/content/pkg/FR-2024-08-14/pdf/2024-17956.pdf) ; [NIST PR](https://www.nist.gov/news-events/news/2024/08/nist-releases-first-3-finalized-post-quantum-encryption-standards) [el Reg](https://www.theregister.com/2024/08/14/nist_postquantum_standards/); [CloudFlare](https://blog.cloudflare.com/another-look-at-pq-signatures/) [NIST March IR](https://csrc.nist.gov/pubs/ir/8545/final) [Digicert re FN-DSA status](https://www.digicert.com/blog/quantum-ready-fndsa-nears-draft-approval-from-nist); [NIST HQC](https://www.nist.gov/news-events/news/2025/03/nist-selects-hqc-fifth-algorithm-post-quantum-encryption)

---




# 3 History Vignette - Midway is low on water

The Battle of Midway was won miles away, weeks before, in a bunker in Hawaii.
⎄

## Historic Context 

Battle of Midway wasn't a surprise landing after-all.

* Spring 1942, months after Pearl Harbor
* Decodes show IJN planning next offensive against "AF"
    * various two-letter codes AH, AK, ... were Hawaiin islands
    * AF should be nearby if consistent
    * inferred must be Midway Is., but not conclusive
* strategem to prove it: feed a Known Plain Text to IJN listeners and hope they send it in code being read
    * Midway sends LOW ON WATER in the clear (as if not considered secret)
    * IJN sends AF LOW ON WATER in JN-25b, intercepted & decrypted.
* USN carriers ambush IJN carriers 



---

## Notes for Historic Context 

* They also had to solve an embedded mini-code for dates to get the June 3 and 4 operational dates.
* [NSA Pub 23](#Pub23), 2004, "How Cryptology enabled the United States to turn the tide in the Pacific War."

> In the spring of 1942, Japanese intercepts began to make referencesto a pending operation in which the objective was designated as "AF." Rochefort and Captain Edwin Layton, Nimitz's Fleet Intelligence Officer, believed "AF" might be Midway since they had seen "A" designators assigned to locations in the Hawaiian Islands. Based on the informationavailable, logic dictated that Midway would be the most probable place for the Japanese Navy to make its next move. Nimitz however, could not rely on educated guesses. 
> In an effort to alleviate any doubt, in mid-May the commandingofficer of the Midway installation was instructed to send a messagein the clear indicating that the installation's water distillationplant had suffered serious damage and that fresh water was neededimmediately. Shortly after the transmission, an intercepted Japaneseintelligence report indicated that "AF is short of water." Armed with this information, Nimitz began to draw up plans to move his carriers ...

* [Rochefort Oral History](#Afterthoughts), preface section 4 "Target is AF":

> Even before the Coral Sea engagement, based on what he was decoding, **Rochefort** predicted a major Japanese attack in the Central Pacific. 
On May 12, the American decoders discovered that the letters **'AF'** symbolized the Japanese code name for their target. 
By May 25th, Rochefort and Captain Edwin Layton, Admiral Chester Nimitz's Fleet Intelligence Officer, were convinced that **'AF' stood for Midway Island**.
Rochefort had even pinpointed the date of the Japanese attack--June 4, 1942 and that a diversionary attack would take place somewhere in or around Alaska around June 3. 
There was just one problem: Rochefort had to convince the Washington 'planners' who would not believe that Midway could possibly be the target that they were wrong. 
Commander Jasper Holmes, Rochefort's assistant, devised a plan to prove that 'AF' was indeed Midway, a plan to which Admiral Chester Nimitz agreed. 
Nimitz instructed Midway to **send a clear text message** that **falsely** reported the island was **low on fresh water**. 
The Japanese obligingly intercepted the message and promptly and dutifully reported that **'AF' was low on fresh water**. 
That was the proof Nimitz needed; he could take action.

* [Hinsley & Stripp](#Hinsley) p. [279](https://archive.org/details/isbn_9780198204794/page/278/mode/1up?q=stripping+%22JN+25%22)
  > JN 25 came in three flavours--a system for flag-officers, which we never had enough messages to make progress with; a system for administrative communications, more or less ignored by the Japanese; and the main system. It was a US JN 25 decrypt which led to the shooting-down of Admiral Yamamoto Ishiroku in the Solomon Islands area on 18 April 1943

(It was the Flag-officer variant that Rochefort's Station HYPO had been dedicated to prior to Dec 7, 1941. They joined the other stations working on general fleet JN-25b by Dec 25th.)

---



---

## Revenge of Pearl Harbor Navy

Only after Pearl Harbor attack was Station HYPO, Navy Cryptological unit there, assigned to the suddenly higher priority "JN-25b" IJN operational code.

* 3rd edition codebook per IJN records, but version "b" in USN records
* 5 digit code-words (code-groups) per word or phrase encoded
* superenciphered by additive key 
* codebook versions reissued periodically
* key table booklets (of 50,000 5-digit random nubmers) reissued more often
* Some progress already made by other stations



----

### NOTES FOR Revenge ...

* recovering a new key fairly easy if codebook already mostly solved and common message patterns known
* recovering additional codegroup meanings somewhat challenging linguistic problem if additive key solved
* when both change, need to collect volume for depths and re-enter using  known common messages.
* Failure to use Russian Copula, discourage routine patterns allows retaining contact!


* [Rochefort's War](#Rochefort) e.g. p.206
  - > Breaking JN-25(b) would be like peeling back the layers of an onion; layer after layer would have to be sliced away and pulled apart before the code inside was revealed. Each code group was disguised by yet another five-digit group of a possible 50,000 random numbers, called additives, contained in a 300-page volume. Called the additive book, this consisted of many pages of five-numeral groups, each available to disguise a code group.
* [Rochefort's oral history](#Afterthoughts).
* See also discusion of [Musicians](#Musicians) recruited into Rochefort's Station HYPO; NSA and Wikipedia bios of Rochefort and Chicago fracas [Web pages](#web-pages).



---



---


## Processing Encicode to find, strip Additive key

* ![IBM 405 offline card tabulator](Images/IBM-405.png){#405 width=30% .float_r} Using IBM 405 Tabulators
* Keypunch leading 16 &#xd7; 5 figure groups per 80 column cards
* Search for coincidences, and common differences
* also for common prefixes of message
* statistical tests; common adjacencies; index of differences seen.
* also cards for known placode groups' Kana (and translation?) to produce (partial) decrypts 



* Encicode :  &#x2014; portmanteau of <u>enci</u>phered <u>code</u>, the numeric or alphabetic codegroup as protected by a superencipherement. (Coined by WFF himself!) See 
* for historical reasons, Pearl Harbor HYPO had dedicated IBM tabulators in the bunker (SCIF) and space to add crew

* [Rochefort's War](#Rochefort) p.39
  > This involved a second book consisting of thousands of additional numerals, called additives. A code clerk on the sending end would simply superimpose a set of randomly chosen numerals on the code groups. Another code clerk on the receiving end looked for a keyword in the message that told him what page to turn to in the additive book to find how the code had been enciphered, thereby enabling him to strip off the additives before looking up

----

### NOTES FOR Processing Encicode

* partial reprise (&#x2673;) of 2018 VENONA slide, as this technique was reused postwar for VENONA, which discovered reuse of OTP additive.
    * [n23](https://blu.org/meetings/2018/09/Crypto-news-2018.flipbook/#page/n23) & [n31](https://blu.org/meetings/2018/09/Crypto-news-2018.flipbook/#page/n31)

* [Kahn](#Kahn) pp.[566](https://archive.org/details/codebreakersstor0000kahn_k4s3/page/566/mode/2up?q=%22difference%22) 

> the codegroup and its meaning were punched on an I.B.M. card and stored in the machine. When an intercept came in, a clerk would punch its codegroups on I.B.M. cards and feed them in. The machine automatically made the run of repeated subtractions and the check of its mechanized difference 'books'' necessary to find the identical remainders, and then, with human guidance, the runs to reconstruct the relative additive sequence, correct it to the absolute sequence, and strip it from the encicode message. The machine would then compare the placode groups with the decode cards in its storage and print out the plaintext for whatever decode cards it had. Presumably it would also print out the various possibilities in the case of garbled or partial codegroups. It could also make frequency counts and contact counts and on command could disgorge a desired set of statistics'all codegroups preceding and following a given codegroup, for example.

* [Stripp, Codebreaker in the Far East](#FarEast) notes 
    - p.105  
      > "In the 1914-18 war some of the additive keys were so short that they repeated frequently, but those easy-going days have gone."
    - Page 196 
      > Kerckhoffs, _La Cryptographie Militaire_ (Paris: Baudoin, 1883 and later reprints). . Kerckhoffs was probably the first person to grasp the significance of what is now called 'reciphering' a code or cipher text by a separate key which can be changed whenever necessary without altering the system. He explained how the cryptanalyst could create a 'superimposition' (nowadays 'build a depth') of different messages reciphered on the same key, and illustrated the principle that the greater the depth, the easier and securer the solution became. Kahn, on pages 236-7, usefully gives letter-by-letter examples of a principle which, as Kerckhoffs shows, applies equally to word-by-word key-breaking. See also the example of key-breaking given in Hinsley and Stripp: _Codebreakers: The Inside Story of Bletchley Park_ (Oxford University Press, 1993) pp.296-9.
    - which references [Kerckhoffs](#Kerckhoffs) and [Hinsley and Stripp](#Hinsley).

* [Rochefort's War](#Rochefort) p.207
  > Once the key was identified (a discovery that might require hours or days), Dyer or Wright turned the task over to another group of cryptanalysts who began the arduous task of 'stripping,' that is, subtracting the false fivedigit groups (or additives) from the underlying code groups. Using additives supplied by Cast, Negat and Hypo's tabulating machines, the strippers (as some wags called them) proceeded to lay bare the actual code groups hidden underneath.
  > Then the job was handed off to the linguists, the Lasswell people, who were, in effect, Hypo's true codebreakers, or 'book breakers,' as they were also called.' Their job was to take the exposed code groups, now stripped of the additive numbers, and from them build a JN-25(b) codebook. The first thing they did was visit Holtwick's boiler factory, the machine room where many JN-25(b) code groups were indexed. Some were already assigned a meaning, in which case the group was considered 'recovered.' But most code groups in the messages intercepted by Station H were blank. Armed with whatever clues they could find in IBM printouts and using their knowledge of Japanese, the linguists then attempted to assign values to as many of the five-digit groups as they could. Then they attempted an initial translation.

---



---

## Method of Differences 

* Calculate (and index and record!) the **differences** of all the <u>encicode</u> groups in a message.
* Using Indicator or Kappa/Chi tests, align messages using common key in depth


![Kahn-441-depth](Images/Kahn-441-depth.png){.float_r} 5 messages in depth

<br clear=all/>

![Kahn-442-differences](Images/Kahn-442-differences.png){.float_r} Difference runs on columns A and E.

* note **`8801`** and **`5909`** are common differences between columns A and E.
* (full differences would show more such)
* subtracting relative difference from all of the column produces relative key and relative placode groups. 

<br clear=all/>





----

### NOTES FOR Method of Differences

* Technique to strip additive with offline tabulators was discovered by at least one German agency as well.

* Figures from [Kahn](#Kahn) pp.[440-443](https://archive.org/details/codebreakersstor0000kahn_k4s3/page/440/mode/2up?q=%22difference+method%22) 

> It is generally called the 'difference method.' The cryptanalyst first identifies, by indicators or traffic analyses or other information, a group of encicode messages that he believes used the same basic code and portions, at least, of the same long additive key. Using repetitions or clues from indicators as anchor points, he places the messages one under another so that the identical portions of the additive key will stand in vertical alignment. '

> He subtracts every encicode group in a column from every other. He subtracts the first group from itself, from the second, third, fourth, and so on, encicode groups, the second group from itself, from the third, fourth, and so on. The differences resulting from these 'runs' are listed in a difference book, which also gives the location of the two encicode groups that produced each difference. The cryptanalyst repeats the subtractions for every column and indexes all differences in the difference book. He then examines this book for two columns that have a difference in common. This common difference indicates that the two columns include the same placode group, which each column has enciphered with its own additive.


---



---

## Book-Breaking 


* Can follow stripping, or can lead stripping.
* first: recover code-groups for stereotyped beginning and end of message
* second: code-groups used for numerals and spelling non-coded-words broken as simple cipher
* already known groups plus context of message (from, to, when, length, military situation) suggest values for first group in a gap
* if a One Part Code, the code and plain-text values are in numeric=alphabetic order, so adjacency is a big hint
* cross-riff messages in depth 
    * which may solve gaps in Additive key-book as well
    * assuming a group in a gap from context implies a difference, which will imply code-groups for messages in depth; do they make all sense too?



----

### NOTES FOR Book-Breaking

* partial reprise (&#x2673;) of 2018 VENONA slide, as this technique was reused postwar for VENONA, which discovered reuse of OTP additive.  [n23](https://blu.org/meetings/2018/09/Crypto-news-2018.flipbook/#page/n23)
* method described in e.g., [Kahn](#Kahn);
* and [Hinsley & Stripp](#Hinsley) p. [279](https://archive.org/details/isbn_9780198204794/page/278/mode/1up?q=stripping+%22JN+25%22) 
    - > Recovery of code-group meanings was called 'book-breaking'. Removal of additive key was called 'stripping', and the ladies and gentlemen who did this were called 'strippers'.

---



---

## Using a Depth 

Example from Hinsley & Stripp: 

![Stripp-298-depth](Images/Stripp-298-depth.png)

Works like an N-dimensional Cross-word puzzle ... but with cells being codewords representing words or phrases, and connections being same-offsets in codeword sequence.



----

### NOTES FOR Using a Depth

* [Hinsley&Stripp](#Hinsley) p.[297..299](https://archive.org/details/isbn_9780198204794/page/298/mode/1up?q=Message+group) 
  > Message No. 1 is inscrutable. No. 2 is clearly a routine report of stocks held. No. 3 offers no help yet. If we try 'large bombs' for the first missing key-group in Message No. 2, the key needed to produce it gives 'our' in No. 1, and 'advance' in No. 3. We are in business. But we are unlikely to spend hours going through all possible numerals to continue No. 2 unless there is a very special reason.
  > To cut a long story short: for the second missing key-group, 'towards' in No. 3 gives 'troops' in No. 1, and '545' in No. 2. For the third, 'incendiary bombs' in No. 2 gives 'were forced to' in No. 1, and 'Mandalay' in No. 3. The fourth is harder: the obvious guess 'abandon' (or a synonym) for No. 1 produces nonsense, but if we assume that one digit has been garbled in reciphering, transmission, or interception'a common phenomenon'it works, giving '2250' in No. 2 and 'intending' in No. 3. Finally, 'delayed-action bombs' in No. 2 gives 'TI' in No. 1 and 'to cross' in No. 3. The sense is clear in Messages No. 2 and No. 3.  ...  
  (_See link above for the rest of the narrative._)

* Another worked example of [Kerckhoff](#Kerckhoff)'s method applied to <u>letter-wise</u> ciphers in depth is in [Barker](#Barker).

---



---

# 4 Bibliography & Footnotes

## My talks

The **YouTube** of this presentation will be linked on [BLU.org](https://BLU.org) along with these slides and extended notes *etc* as [2025-sep](http://blu.org/cgi-bin/calendar/2025-sep) as per usual.

[**Prior talks in this series**](http://blu.org/cgi-bin/calendar/speakers/b-ricker1) - most talks have slides &/or YouTube attached, sometimes extras.  
_Alas the YouTube audio pre-pandemic wasn't great, BLU will need a donation of a wireless clip-on mike if we ever return to Hybrid/In-Person meetings. Or we all need to wear a wired or BT headset while presenting in person?_

## News + Focus 

**News** and **Focus** sections have embedded links. 

Good security news streams to either research history or to follow year round are [Scneier Crypto-gram](https://www.schneier.com/crypto-gram/) and [SANS ISC](https://isc.sans.edu/), the latter being less cryptologic and more operational in focus -- but both cover the wide span of vulnerabilities, tools, remediations, etc, not just the cryptologic that I'm cherry-picking here.    
**Highly recommended**.    
_Start your day with the 5 minute SANS Internet Storm Center StormCast pod-cast; the Red Team is, so, so should you._


## Cryptologic History -- general references

* [**_Bletchley Park Podcast_**](https://duckduckgo.com/?t=ffab&q=Bletchley+Park+Podcast) on your favorite pod server
    * [FB](https://www.facebook.com/BletchleyParkPodcast/)
    * BPP [Keyword index](file:///home/wdr/Bill/git-other/articles/Cryptology/BletchleyParkPod/BPP-Keywords.html)    
      _by me, current thru fall '22_ 
    ![Code-Breakers](Images/Code-Breakers.jpg){width=20% .float_r} 
* **Books**
    * _The Code Breakers_,  revised & updated; [Kahn, David](https://en.wikipedia.org/wiki/David_Kahn_%28writer%29); 1996: NY S&S. 
    * _Decrypted Secrets_; Bauer, F.L.; 1997, 2006: Heidelberg, Springer. [IA:Borrow](https://archive.org/search?query=bauer+decrypted+secrets)
    * [Schneier books](https://www.schneier.com/books/)
* **Websites**
    * [Wikipedia](https://en.wikipedia.org/wiki/Cryptography); [Bibliography of](https://en.wikipedia.org/wiki/Bibliography_of_cryptography)
    * [Cipher History](https://cipherhistory.com/)  
    * [CryptoMuseum](https://cryptomuseum.com/)  
    * [NSA History](https://www.nsa.gov/History/Cryptologic-History/)
    * [GWU NSArchive](https://nsarchive.gwu.edu/)  (Academic National Security Archive at GWU; FOIA Declassified)
    * Declassified post-WW2 [**TICOM**](https://en.wikipedia.org/wiki/TICOM) [reports](http://www.ticomarchive.com/) (_Signals and Cryptologic Intelligence equivalent of better-known Operation Paperclip, etc._)


## Cryptologic History -- 2025  -- Glossary

* additive &#x2014; numerical **superenchipherment** key, added to book numeric code group (added without carry)
* additive book = **key-table**
* cipher - cryptographic protection of text via operations on the text (typically characters) rather than semantic units (words); substitution and transposition are the classical categories.
* code &#x2014; cryptographic replacement of semantic units, whole words and phrases, with words or (typically fixed size) sequence letters or digits. Hence "four digit code", "five digit code", "five letter code".
* depth &#x2014; several messages sent in same time-span of a key, which must be aligned, which can be used to solve each message relative to the others.
* encicode &#x2014; portmanteau of <u>enci</u>phered <u>code</u>, the numeric or alphabetic codegroup as protected by a superencipherement.
* indicator &#x2014; a group inserted into a message that *looks like* an **encicode** group but actually <u>indicates</u> the offset into a "large"? table of **key** groups where the message **additive** starts. ?(_"large" for manual encipherment turns out to be small for automated processing on IBM Hollerith Tabulators, let alone modern computers._)
* key(s) &#x2014; secret value(s) used with a method to encipher and decipher. In **superencipher**ed **code**, the key is typically an **additive**, a sequence of one, several, or very many nonsense numeric groups.
* key book, key table &#x2014;in WW2 codes, periodical secret booklet of several thousand numerical codegroups to be used as **additive** key for it's period of validity (one to three months). See **indicator**. The replacement key-book must be distributed to all stations before cut-over, else some messages may be sent in both old and new key which is a compromise if noticed (same length same day from same station is a major "tell"!)
* key-breaking &#x2014; wrto book-codes, the hard phase of **key-stripping**. (Can also be used wrto recovering day-key of rotor systems, where "setting" "wheel breaking" are specific forms.) 
* key-stripping &#x2014; reduction of intercepted **encicode** to relative or absolute **placode** groups. If current key-book (mostly) already recovered, **indicator** may allow direct mechanical stripping (on IBM Hollerith Tabulators); if not, requires aligning in **depth** and differencing to find common differences. 
* placode &#x2014; portmanteau of <u>pla</u>in <u>code</u>, the numeric or alphabetic code group listed in the codebook, distinguished from <u>encicode</u>.
* subtractive &#x2014; UK usage for additive key (because cryptanalysis required subtracting the additive added in encipherement)
* superencipherment &#x2014; protection of code-groups of a Code proper. Typically via an **additive** key, but transposition or combination of transposition and substitution also historically used. The **placode** is the unprotected codegroup(s), and the **encicode** is the protected codegroup(s).
* superimposition = depth

references: [Kahn](#Kahn) and others in bibliography.

## Cryptologic History -- 2025 -- topic-specific

My 2018 vignette on VENONA OTP touched [on book-breaking](https://blu.org/meetings/2018/09/Crypto-news-2018.flipbook/#page/n23) as well.

### &#x1F56E; books \& &#x1f4d1; whitepapers

'IA' indicates available at [Internet Archive](https://archive.org/).

* &#x1F56E; <span id="Barker">Barker, Wayne G.;</span> _Cryptanalysis of an enciphered code problem : where an "additive" method of encipherment has been used_; 
1979; Laguna Hills, Calif. : Aegean Park Press;
    - [IA](https://archive.org/details/cryptanalysis-of-an-enciphered-code-problem.-wayne-g-barker.-c-26/page/n1/mode/2up)
    - > Text provides a hands-on problem: an enciphered code problem with text in English that duplicates an actual Italian system used in Libya in 1940. The student is shown how to solve the problem with the concept of "differences" as applied to the analysis of an additive system being discussed in detail, and shown the use of "difference tables," etc.
* &#x1F56E;![RochefortsWar](Images/RochefortsWar.jpg){ .float_r } <span id="Rochefort">Carlson, Elliot; [_Joe Rochefort's war : the odyssey of the codebreaker who outwitted Yamamoto at Midway_](https://search.worldcat.org/search?q=ti%3AJoe+Rochefort%27s+War&offset=1); 2013; Naval Institute Press.</span>
    - Thank you to **Federico Lucifredi** who gifted me a copy of this book!
    - The book on Station Hypo, JN-25b, and Midway.
    -  [IA Borrow](https://archive.org/search?query=Joe+Rochefort%27s+War) 
    - Appendix 1: "Rochefort's DSM Citation" p.457
    - Appendix 2: "Breaking JN-25(b)" pp.458-460; has (created) example message
    - Appendix 3: "The Meaning of Midway" p.461ff.
    - Appendix 4. "The _Kido Butai_ and Radio Silence" p.465ff.    
      [[_Kidō Butai_](https://en.wikipedia.org/wiki/1st_Air_Fleet#Kid%C5%8D_Butai) = 機動部隊, "Mobile Strike Force" = the collection of the IJN Fleet Carriers supporting the First Air Fleet (第一航空艦隊, _Daiichi Kōkū Kantai_) of the Imperial Japanese Navy, and by implication, upto five Divisions (pairs) of Aircraft Carriers plus supporting capital, escort, and support vessels; 3 Divisions or 6 Carriers in the Pearl Harbor mobile strike task force.]
    - pp. 39, 206, 207 cited; much more useful background.
    - Glossary pp. 539-541
* &#x1f4d1; <span id="AusBiblio">Donovan & Mack, [_Annotated Bibliography on Cryptography in Australia in WW2_](https://www.maths.usyd.edu.au/u/WW2Codes/biblio.pdf)</span>; Peter Donovan,
John Mack. Includes excerpts; esp. re F.H.Hinsley, p.10, and Huh Melinsky, p.15. See also [USydney+UNSW WW2 Codes project homepage](https://www.maths.usyd.edu.au/u/WW2Codes/) and linked popular-press article.
* &#x1F56E; <span id="Hinsley">Hinsley & Stripp,  [_Codebreakers: the inside story of Bletchley Park_](https://search.worldcat.org/formats-editions/46333962) [IA Borrow 1](https://archive.org/details/codebreakersinsi00hins/page/286/mode/2up?q=stripping), [2](https://archive.org/details/isbn_9780198204794)</span>
    - p.[297](https://archive.org/details/isbn_9780198204794/page/297/mode/1up?q=stripping+%22JN+25%22) ff has example of breaking a new stretch of additive
    - breaking a new key-table requires depth and mostly good code-book recovery (and any subsidiary re-cipher), or known-plaintext &/or cribs.
    - Part 5 Japanese Codes  &#xA7;26-30 pp.255-305.
    - adders (US) = subtractors (UK)
    - Italian naval book-breaking pp.61-63
    - p.279, "book breaking"; JN-25 variants.

* &#x1F56E; Kahn, D.; <span id="Kahn">[_The Codebreakers_](https://search.worldcat.org/formats-editions/35159231), 1967-1968, 1997 (rev).  
    - IA [Search only](https://archive.org/search?query=Kahn+%22The+Codebreakers%22) </span>

* Kerckhoffs, <span id="Kerckhoffs">_La Cryptographie Militaire_ (Paris: Baudoin, 1883 and later reprints). [(Fr.) &#x1F56E;](https://archive.org/details/lacryptographie00kercgoog) [(Fr.) &#x1f4d1; 1st appearance in journal](https://archive.org/details/117Kerckhoffs/page/18/mode/2up); [(En.) &#x1f4d1; (Trans. for American Cryptogram Assoc., 1964)](https://archive.org/details/kerckhoffs.translated.pdf/page/31/mode/2up). </span>
    - p.[31f](https://archive.org/details/kerckhoffs.translated.pdf/page/31/mode/2up) shows solving mixed alphabet with repeating key with several messages in **depth**. The same technique applied to encicode words (instead of ciphertext characters) is used for **stripping** additives to relative or absolute **placode**. This is foundational, and cited and quoted in most of the later books.
* &#x1f4d1; <span id="Musicians">Prescott, Kyle; "Musician Cryptologists: The Band of the USS California at Pearl Harbor and Beyond"; in _Proceedings of the 7th International Conference on Historical Cryptology (HistoCrypt 2024)_; [abstract and download](https://dspace.ut.ee/items/b3ae5463-3b04-4d04-aee3-771b65a0fc10) </span>  
    - > **Abstract** Working from the basement of US Pacific Fleet Headquarters in Pearl Harbor from 1941, a small team of navy cryptanalysts and linguists known as the Combat Intelligence Unit (CIU) provided the US Pacific Fleet Command with timely details of the capabilities and intentions of the Japanese Imperial Navy (IJN) in the Pacific. A substantial portion of the CIU was comprised of 20 enlisted musicians of US Navy Unit Band 16, the band of the USS California (BB-44), who survived the sinking of their ship in the attack of December 7, 1941. The musicians were recruited to Combat Intelligence, retrained to perform tasks related to the deciphering of Japanese Naval Code JN-25b, and contributed to that unit's celebrated intelligence successes of 1942. As the war waged on, several musicians from Band 16 transferred to the Naval Communications Complex at Nebraska Avenue in Washington DC, and three eventually joined the National Security Agency (NSA) and served through the height of the Cold War.
* &#x1F56E; Stripp, Alan; <span id="FarEast">[_Codebreaker in the Far East_](https://search.worldcat.org/formats-editions/19263537) [IA](https://archive.org/details/codebreakerinfar0000stri_p4a4/page/196/mode/2up?q=Kerckhoffs+Additive); 1993; IA Search only.</span>
    - cites [Kerckhoffs](#Kerckhoffs), p. 105, notes 64 & 65, p.196; 
    - Additive, p.71, 90, 105, 126, 196. 

### Web pages

* [NSA Biography of Joe Rochefort](https://www.nsa.gov/about/cryptologic-heritage/historical-figures-publications/hall-of-honor/2000/jrochefort.shtml); Wikipedia notes it has incorrect birth year (1898, given elsewhere as 1900-05-12).
* [Wikipedia: Joseph Rochefort](https://en.wikipedia.org/wiki/Joseph_Rochefort)
* "[Unsealed 75 years after Battle of Midway](https://www.washingtonpost.com/news/retropolis/wp/2017/06/05/unsealed-75-years-after-the-battle-of-midway-new-details-of-a-critical-wwii-press-leak/), by Michael E. Ruane, June 19, 2020, in WaPo Retropolis.  
    - > New details of alarming WWII press leak. The Chicago Tribune printed the big secret. Fortunately, the Japanese apparently didn't read the Tribune.
    - US Naval Institute (parent of N.I.Press) reviews WaPo review of their book:  
    - > The Washington Post has featured Naval Institute Press author, Elliot Carlson and the story behind his forthcoming book: STANLEY JOHNSTON'S WAR: THE REPORTER WHO SPILLED THE SECRET BEHIND THE U.S. NAVY'S VICTORY AT MIDWAY.
    - Forthcoming titles sometimes change in press; this was actually released as [_Stanley Johnston's Blunder_](https://search.worldcat.org/formats-editions/1000298024), same subtitle, 2017, NIP:Annapolis, Perseus Book (Ingram), Audible.
    - See also [Nat.Sec.Arch. "Secrecy And Leaks: When The U.S. Government Prosecuted The Chicago Tribune -- Lessons On Sources And Methods From The Battle Of Midway, 1942"](https://nsarchive.gwu.edu/briefing-book/intelligence/2017-10-25/secrecy-leaks-when-us-government-prosecuted-chicago-tribune), John Prados;  & [Nuc.Mus.](https://ahf.nuclearmuseum.org/history-article-roundup-june-2017/)
* The National WWII Museum
    * Secret WWII: Spies & Special Ops podcast series [YT playlist](https://www.youtube.com/playlist?list=PLfTt9Iv9fryU7HpjcDm3jgmLZGp-kGBmt) Part 1 mentions Station HYPO in intro, release 2025-09-18. (part 1 discusses Army break of Japanese diplomatic PURPLE machine slightly, mostly discusses upgrading of Donovan's OSS at behest of Brit secret services.)

* **Wayback Machine**
    - <span id="Pub23">NSA Pub.23 ["The Battle of Midway: "AF is Short of Water"](https://web.archive.org/web/20061209193829/http://www.nsa.gov/publications/publi00023.cfm), 2004, "How Cryptology enabled the United States to turn the tide in the Pacific War."</span>
    - <span id="Afterthoughts">_Cryptological Afterthoughts_, excerpts from CRYPTOLOG? the journal of The U.S. Naval Cryptologic Veterans Association; **CAPT Rochefort's oral history** interview in 1969. [1](https://web.archive.org/web/20131227092441/http://www.usncva.org/clog/pearl1.shtml), [2](https://web.archive.org/web/20120206023445/http://www.usncva.org/clog/pearl2.shtml), [3](https://web.archive.org/web/20131227093016/http://www.usncva.org/clog/smok_jkt.shtml), [4](https://web.archive.org/web/20120206023505/http://www.usncva.org/clog/leyte.shtml), [5: Midway](https://web.archive.org/web/20080829170609/www.usncva.org/clog/midway.shtml), [6](https://web.archive.org/web/20131227091559/http://www.usncva.org/clog/cryppy.shtml); [7](https://web.archive.org/web/20131227092918/http://www.usncva.org/clog/corregidor.html); </span>
    - <span id="About">about.com: [Americas Code Breaker: Rochefort's banishment, Herb Kugel](https://web.archive.org/web/20060520052841/militaryhistory.about.com/cs/worldwar2/a/codebreakerhk_5.htm), a continuation of [Americas Code Breaker (1)](https://web.archive.org/web/20070419151206/http://militaryhistory.about.com/cs/worldwar2/a/codebreakerhk.htm) [(2)](https://web.archive.org/web/20060618145708/http://militaryhistory.about.com/cs/worldwar2/a/codebreakerhk_2.htm) [(3)](https://web.archive.org/web/20070322033547/http://militaryhistory.about.com/cs/worldwar2/a/codebreakerhk_3.htm) [(4) Target AF](https://web.archive.org/web/20070322033556/http://militaryhistory.about.com/cs/worldwar2/a/codebreakerhk_4.htm) </span>
* **DTIC** ([Defense Technical Information Center](https://discover.dtic.mil/)) War College etc theses on adjacent topics; unclassified unrestricted military academic papers. Many (all below) shadowed on IA.
    - [ADA471458](https://archive.org/details/DTIC_ADA471458) More to the Story- A Reappraisal of U.S. Intelligence Prior to the Pacific War ACGSC
    - [ADA264391](https://archive.org/details/DTIC_ADA264391) Intelligence and Surprise- The Battles of Midway NWC
    - [ADA417552](https://archive.org/details/DTIC_ADA417552) Evolution: Advancing Communities of Practice in Naval Intelligence NPGS
    - [ADA583353](https://archive.org/details/DTIC_ADA583353) Navy Information Dominance, the **Battle of Midway**, and the Joint Force Commander: It Worked Then, It Needs to Work Now NWC
    - [ADA351751](https://archive.org/details/DTIC_ADA351751) Operational Intelligence at the Battle of Midway NWC
    - [ADA193977](https://archive.org/details/DTIC_ADA193977) The Japanese Attack on Darwin: 19 Feb 42 : A Case
Study in Surprise at the Operational Level AWC
    - [ADA505406](https://archive.org/details/DTIC_ADA505406) A Comparative Analysis of the Military Leadership Styles of Ernest J. King and Chester W. Nimitz ACGSC 
    - **ACGSC** = Army Command & General Staff College; **NWC** = Naval War College; **AWC** = Army War College; **NPGS** = Naval Post Graduate School.

------------


## Title {Item Template} 

text 

* bullets



----

### NOTES FOR {item}

* (note)

---



---
