#! /bin/bash

set -x

yy=25
fn=Crypto-20$yy.md
fnroot=${fn%.*}
while true
do inotifywait -e modify pandoc.css slidy-template.Thtml $fn
    pandoc --from=markdown --css pandoc.css --to=slidy --template=slidy-template.Thtml   $fn --slide-level=2 -o $yy.slidy.html
    perl -plE 's/^:::(?x: \s* notes \b)?\s*$//d;' $fn > $fnroot-notes.md
    pandoc --from=markdown --css pandoc.css --to=html -s --toc --toc-depth=1 $fnroot-notes.md  -o $yy.doc.html; echo $?; 
    date

done
